# -*- coding: utf-8 -*-
# Get device data from Pids3


def Crc32(s, previouscrc=0):
    polynomial = 0xEDB88320
    crc = ~previouscrc & 0xffffffff

    for c in s:
        crc ^= ord(c)
        for bit in range(8):
            crc = (crc >> 1) ^ ((crc & 1) * polynomial)

    return ~crc & 0xffffffff


def FormatAdxMessage(command, parameter=""):
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    addr = '%08X' % 0
    msg = command
    if parameter != "":
        msg += " " + parameter

    chks = Crc32(addr)
    chks = Crc32(chr(2), chks)
    chks = Crc32(msg, chks)
    chks = Crc32(chr(3), chks)

    outputfmt = "\x01{}\x02{}\x03{:08X}\x04"
    return outputfmt.format(addr, msg, chks)
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


def ParseAdxMessage(rx):
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    sx = str(rx, 'utf-8')
    # print(sx)

    sx = sx.replace('\x01', '|')
    sx = sx.replace('\x02', '|')
    sx = sx.replace(' ', '|', 1)
    sx = sx.replace('\x03', '|')
    sx = sx.replace('\x04', '|')

    framelist = sx.split('|')
    # print(framelist)
    # TODO : sanity check, e.g. lenght, crc32
    #       address     , command     , parameter   , checksum
    return (framelist[1], framelist[2], framelist[3], framelist[4])
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


def Transmit(command, parameter=""):
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    tx = FormatAdxMessage(command, parameter)
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    # Opens and sends data
    from machine import UART, Pin
    uart1 = UART(1, 1000000)
    uart1.init(timeout=100, tx=Pin(8), rx=Pin(9))
    uart1.write(tx)
    rx = uart1.read(512)
    uart1.deinit()

    # tx = b'\x0100000000\x02device ?\x03969D9250\x04'
    # rx = tx
    return ParseAdxMessage(rx)
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


def ParameterAsFloatArray(par):
    return [float(i) for i in par.split(";")]


def UnitTest_Format():
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    print("Test 1")
    # 00000000 0x2 device ? 0x3
    # chks = 2526909008 ( 0x969D9250 )
    tx = FormatAdxMessage("device", "?")
    print("Message :" + tx)
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    print("Test 2")
    tx = FormatAdxMessage("device ?")
    print("Message :" + tx)
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    print("Test 3")
    rx = Transmit("device ?")
    print("Command  :" + rx[1])
    print("Paramter :" + rx[2])
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


def UnitTest_SerialReadWrite():
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    import time
    from machine import UART, Pin

    print("open uart 1")
    # uart1 = UART(1, baudrate=115200, tx=Pin(8), rx=Pin(9))
    uart1 = UART(1, baudrate=1000000, tx=Pin(8), rx=Pin(9))

    tx = FormatAdxMessage("device ?")
    print(tx.encode())

    uart1.write(tx)
    time.sleep(0.1)
    rx = uart1.read(128)

    print(rx)
    # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


def Pid_Start(): Transmit("pid.start")


def Pid_Stop(): Transmit("pid.stop")


def Pid_ReadValues():
    sx = ""
    try:
      state = Transmit("pid.state ?")
      print("State is {}".format(state[2]))

      rxmsg = Transmit("pid.values ?")
      # rxmsg = Transmit("pid.values 1.23;1.23;1.23;1.23")
      values = ParameterAsFloatArray(rxmsg[2])

      sx = "Conc  {:0.2f} ppm\n".format(values[0])
      sx += "Curr  {:0.2f} pA\n".format(values[1])
      sx += "Temp  {:0.1f} °C\n".format(values[2])
      sx += "Humid {:0.1f} rH\n".format(values[3])
      sx += "Flow  {:0.1f} %\n".format(values[4])

    except:
      sx = "Module not connected"

    print(sx)
    return sx


# main
# UnitTest_Format()
# UnitTest_SerialReadWrite()

Pid_Start()
Pid_ReadValues()
Pid_Stop()
